<?php
/* --------------------------------------------------------------
 ConfigurationGroupId.php 2019-10-18
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Models\Read;

/**
 * Class ConfigurationGroupId
 * @package Gambio\Core\Configuration\Models
 */
class ConfigurationGroupId
{
    /**
     * @var int
     */
    private $group;
    
    
    /**
     * ConfigurationGroup constructor.
     *
     * @param int $group
     */
    private function __construct(int $group)
    {
        $this->group = $group;
    }
    
    
    /**
     * Factory method for ConfigurationGroup.
     *
     * @param int $group
     *
     * @return ConfigurationGroupId
     */
    public static function create(int $group): self
    {
        return new static($group);
    }
    
    
    /**
     * Groups accessor.
     *
     * @return int
     */
    public function group(): int
    {
        return $this->group;
    }
}